<!DOCTYPE html>

<html lang="en">

<?php
    require_once("connect-db.php");

    $sql = "select * from house";
    $statement = $db->prepare($sql);
    if($statement->execute()){
        $homes = $statement->fetchAll();
        $statement->closeCursor();
    }
?>

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>D&B Realty</title>
	<link href="stylesheet.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div class="container">
        <?php include("header_nav.html");?>
        <main>
            <h2>All Homes:</h2>
            <a href="add.php" id="button">(Add Home)</a>
            <table>
                <?php
                    foreach($homes as $h){
                ?>
                <tr>
                    <td>
                        <img src="<?php echo $h["img"];?>">
                    </td>
                    <td>
                        <p>$<?php echo $h["price"];?></p>
                        <p><?php echo $h["bedrooms"];?> bedroom(s)</p>
                        <p><?php echo $h["bathrooms"];?> bathroom(s)</p>
                        <p><?php echo $h["home_footage"];?> sq feet</p>
                        <p><?php echo $h["land_footage"];?> sq foot lot</p>
                        <p><?php echo $h["address"];?>, <?php echo $h["city"];?>, <?php echo $h["state"];?></p>
                        <p>Property Type: <?php echo $h["type"];?></p>
                        <p>HOA Fees: $<?php echo $h["fees"];?>/mo</p>
                        <form action="update.php" method="POST">
                            <input type="hidden" name="home_id" value="<?php echo $h["home_id"];?>">
                            <button type="submit">Update/Sold</button>
                        </form>
                    </td>
                </tr>
                <?php
                    }
                ?>
            </table>
        </main>
        <?php include("footer.html");?>
    </div>
</body>

</html>