<!DOCTYPE html>

<html lang="en">

<?php
    require_once("connect-db.php");

    $sql = "select * from house order by rand() limit 1";
    $statement = $db->prepare($sql);
    if($statement->execute()){
        $homes = $statement->fetchAll();
        $statement->closeCursor();
    }
?>

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>D&B Realty</title>
	<link href="stylesheet.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div class="container">
        <?php include("header_nav.html");?>
        <p>Dirk and Benji are two realtor brothers in California. They strive to make the process of buying a home or property easy! Dirk and Benji are both highly experienced, both having 15 years in the housing industry. What is a realtor, you might ask? Well a realtor is a person who acts as an agent for the sale and purchase of buildings and land, in particular a member of the National Association of Realtors; a real estate agent. The next time you need a realtor, give Dirk and Benji a try!</p>
        <main>
            <h2>Featured Home:</h2>
            <table>
                <?php
                    foreach($homes as $h){
                ?>
                <tr>
                    <td>
                        <img src="<?php echo $h["img"];?>">
                    </td>
                    <td>
                        <p>$<?php echo $h["price"];?></p>
                        <p><?php echo $h["bedrooms"];?> bedroom(s)</p>
                        <p><?php echo $h["bathrooms"];?> bathroom(s)</p>
                        <p><?php echo $h["home_footage"];?> sq feet</p>
                        <p><?php echo $h["land_footage"];?> sq foot lot</p>
                        <p><?php echo $h["address"];?>, <?php echo $h["city"];?>, <?php echo $h["state"];?></p>
                        <p>Property Type: <?php echo $h["type"];?></p>
                        <p>HOA Fees: $<?php echo $h["fees"];?>/mo</p>
                        <form action="contact.php" method="POST">
                            <input type="hidden" name="home_id" value="<?php echo $h["home_id"];?>">
                            <button type="submit">Request More Information</button>
                        </form>
                    </td>
                </tr>
                <?php
                    }
                ?>
            </table>
        </main>

        <?php include("footer.html");?>
    </div>
</body>

</html>