<!DOCTYPE html>

<html lang="en">

<?php
    require_once("connect-db.php");
    
    if($_SERVER["REQUEST_METHOD"]=="POST"){
        $home_id=$_POST["home_id"];

            $sql = "select * from house where home_id = :home_id";
            $statement = $db->prepare($sql);
            $statement->bindValue(":home_id", $home_id);

            if($statement->execute()){
                $homes = $statement->fetchAll();
                $statement->closeCursor();
            }
    }
?>

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>D&B Realty</title>
	<link href="stylesheet.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div class="container">
        <?php include("header_nav.html");?>
        <main>
            <h2>Update Home</h2>
                <form action="process-home.php" method="POST">
                    <?php foreach($homes as $h){?>
                        <input type="hidden" name="home_id" value="<?php echo $h["home_id"];?>">
                        <label>Image Path:</label><br>
                            <input type="text" name="img" required value="<?php echo $h["img"];?>"><br>
                        <label>Price:</label><br>
                            <input type="number" name="price" required value="<?php echo $h["price"];?>"><br>
                        <label>Bedrooms:</label><br>
                            <input type="number" name="bedrooms" required value="<?php echo $h["bedrooms"];?>"><br>
                        <label>Bathrooms:</label><br>
                            <input type="number" name="bathrooms" required value="<?php echo $h["bathrooms"];?>"><br>
                        <label>Home sq Feet:</label><br>
                            <input type="number" name="home_footage" required value="<?php echo $h["home_footage"];?>"><br>
                        <label>Land sq Feet:</label><br>
                            <input type="number" name="land_footage" required value="<?php echo $h["land_footage"];?>"><br>
                        <label>Address:</label><br>
                            <input type="text" name="address" required value="<?php echo $h["address"];?>"><br>
                        <label>City:</label><br>
                            <input type="text" name="city" required value="<?php echo $h["city"];?>"><br>
                        <label>State:</label><br>
                            <input type="text" name="state" maxlength="2" required value="<?php echo $h["state"];?>"><br>
                        <label>HOA Fees:</label><br>
                            <input type="number" name="fees" required value="<?php echo $h["fees"];?>"><br>
                        <label>Property Type:</label>
                            <input type="radio" name="type" value="Single Family" required <?php if(strpos($h["type"], "Single Family")!==false){?> checked="checked" <?php }?>><label>Single Family</label>
                            <input type="radio" name="type" value="Condo" <?php if(strpos($h["type"], "Condo")!==false){?> checked="checked" <?php }?>><label>Condo</label>
                            <input type="radio" name="type" value="Land" <?php if(strpos($h["type"], "Land")!==false){?> checked="checked" <?php }?>><label>Land</label><br>
                        <label>Status:</label>
                            <input type="radio" name="status" value="Market" required <?php if(strpos($h["status"], "Market")!==false){?> checked="checked" <?php }?>><label>Market</label>
                            <input type="radio" name="status" value="Sold" <?php if(strpos($h["status"], "Sold")!==false){?> checked="checked" <?php }?>><label>Sold</label><br>
                    <?php }?>
                    <input type="submit" value="Update">
                </form>
        </main>
        <?php include("footer.html");?>
    </div>
</body>

</html>