<!DOCTYPE html>
<html>

<?php
    require_once("connect-db.php");

    $sql1 = "select * from add_donut";
    $statement1 = $db->prepare($sql1);
    if($statement1->execute()){
        $donuts = $statement1->fetchAll();
        $statement1->closeCursor();
    }

    $sql2 = "select * from add_coffee";
    $statement2 = $db->prepare($sql2);
    if($statement2->execute()){
        $coffee = $statement2->fetchAll();
        $statement2->closeCursor();
    }
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Dirk's Donuts</title>
    <link rel="stylesheet" href="stylesheet.css" type="text/css">
</head>

<body>
    <div class="container">
        <?php include("header_nav.html");?>
        <article>
            <h2>Food List</h2>
            <table>
                <tr>
                    <th>Menu Item</th>
                    <th>Flavor/Strength</th>
                    <th>Price</th>
                    <th>Quantity/Lbs</th>
                    <th>Update</th>
                    <th>Delete</th>
                </tr>
                <?php
                    foreach($donuts as $d){
                ?>
                <tr>
                    <td><?php echo $d["donut_name"];?></td>
                    <td><?php echo $d["flavor"]; echo "<br>"; echo $d["toppings"];?></td>
                    <td>$<?php echo $d["donut_price"];?></td>
                    <td><?php echo $d["quantity"];?></td>
                    <td><form action="update-food.php" method="GET">
                        <input type="hidden" name="donut_id" value="<?php echo $d["donut_id"];?>">
                        <input type="hidden" name="food" value="donut">
                        <button type="submit">Update</button>
                    </form></td>
                    <td><form action="delete-food.php" method="GET" onsubmit="return confirm('Do you really want to delete this?');">
                        <input type="hidden" name="donut_id" value="<?php echo $d["donut_id"];?>">
                        <input type="hidden" name="food" value="donut">
                        <button type="submit">Delete</button>
                    </form></td>
                </tr>
                <?php
                    }
                    foreach($coffee as $c){
                ?>
                <tr>  
                    <td><?php echo $c["coffee_name"];?></td>
                    <td><?php echo $c["strength"];?></td>
                    <td>$<?php echo $c["coffee_price"];?></td>
                    <td><?php echo $c["lbs"];?> lbs</td>
                    <td><form action="update-food.php" method="GET">
                        <input type="hidden" name="coffee_id" value="<?php echo $c["coffee_id"];?>">
                        <input type="hidden" name="food" value="coffee">
                        <button type="submit">Update</button>
                        </form></td>
                    <td><form action="delete-food.php" method="GET" onsubmit="return confirm('Do you really want to delete this?');">
                        <input type="hidden" name="coffee_id" value="<?php echo $c["coffee_id"];?>">
                        <input type="hidden" name="food" value="coffee">
                        <button type="submit">Delete</button>
                        </form></td>
                </tr>
                <?php
                    }
                ?>
            </table>
        </article>
        <footer>
            <h3>Dirk's Donuts</h3>
        </footer>
    </div>
</body>

</html>