<!DOCTYPE html>
<html>

<?php
    require_once("connect-db.php");
    
    if($_SERVER["REQUEST_METHOD"]=="GET"){
        if($_GET["food"]=="donut"){
            $donut_id=$_GET["donut_id"];

            $sql1 = "select * from add_donut where donut_id = :donut_id";
            $statement1 = $db->prepare($sql1);
            $statement1->bindValue(":donut_id", $donut_id);

            if($statement1->execute()){
                $donuts = $statement1->fetchAll();
                $statement1->closeCursor();
            }
        }else{
            $coffee_id=$_GET["coffee_id"];
            
            $sql2 = "select * from add_coffee where coffee_id = :coffee_id";
            $statement2 = $db->prepare($sql2);
            $statement2->bindValue(":coffee_id", $coffee_id);

            if($statement2->execute()){
                $coffee = $statement2->fetchAll();
                $statement2->closeCursor();
            }
        }
    }
?>
</script>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Dirk's Donuts</title>
    <link rel="stylesheet" href="stylesheet.css" type="text/css">
</head>

<body>
    <div class="container">
        <?php include("header_nav.html");?>
        <article>
            <div id="div1">
                <h2>Update Donut</h2>
                <form action="process-food.php" method="GET">
                    <?php foreach($donuts as $d){?>
                        <input type="hidden" name="donut_id" value="<?php echo $d["donut_id"];?>">
                        <input type="hidden" name="food" value="donut">
                        <label>Donut Name:</label><br>
                        <input type="text" name="donut_name" required value="<?php echo $d["donut_name"];?>"><br>
                        <label>Donut Flavor:</label><br>
                        <input type="text" name="flavor" required value="<?php echo $d["flavor"];?>"><br>
                        <label>Donut Price:</label><br>
                        <input type="text" name="donut_price" required value="<?php echo $d["donut_price"];?>"><br>
                        <label>Donut Toppings:</label>
                            <input type="checkbox" name="toppings[]" value="sprinkles" <?php if(strpos($d["toppings"], "sprinkles")!==false){?> checked="checked" <?php }?>><label>Spinkles</label>
                            <input type="checkbox" name="toppings[]" value="nuts" <?php if(strpos($d["toppings"], "nuts")!==false){?> checked="checked" <?php }?>><label>Nuts</label>
                            <input type="checkbox" name="toppings[]" value="cookies" <?php if(strpos($d["toppings"], "cookies")!==false){?> checked="checked" <?php }?>><label>Cookies</label><br>
                        <label>Donut Quantity:</label><br>
                        <select name="quantity">
                            <option value="<?php echo $d["quantity"];?>"><?php echo $d["quantity"];?></option>
                            <option value="12">12</option>
                            <option value="24">24</option>
                            <option value="36">36</option>
                        </select><br>
                    <?php }?>
                    <input type="submit" value="Update Donuts">
                </form>
            </div>
            <div id="div2">
                <h2>Update Coffee</h2>
                <form action="process-food.php" method="GET">
                    <?php foreach($coffee as $c){?>
                        <input type="hidden" name="coffee_id" value="<?php echo $c["coffee_id"];?>">
                        <input type="hidden" name="food" value="coffee">
                        <label>Coffee Name:</label><br>
                        <input type="text" name="coffee_name" required value="<?php echo $c["coffee_name"];?>"><br>
                        <label>Coffee Strength:</label><br>
                        <input type="text" name="strength" required value="<?php echo $c["strength"];?>"><br>
                        <label>Coffee Price:</label><br>
                        <input type="text" name="coffee_price" required value="<?php echo $c["coffee_price"];?>"><br>
                        <label>Coffee Lbs:</label>
                        <select name="lbs">
                            <option value="<?php echo $c["lbs"];?>"><?php echo $c["lbs"];?></option>
                            <option value="1">1</option>
                            <option value="2">2</option>
                            <option value="3">3</option>
                        </select><br>
                    <?php }?>
                    <input type="submit" value="Update the Coffee">
                </form>
            </div>

        </article>
        
        <footer>
            <h3>Dirk's Donuts</h3>
        </footer>
    </div>
</body>

<?php 
    if($_GET["food"]=="donut"){
        echo "<script>";
            echo "div2.style.display = 'none'";
        echo "</script>";
    }else{
        echo "<script>";
            echo "div1.style.display = 'none'";
        echo "</script>";
    }
?>

</html>